// GnuRad 
// Copyright 1997, Ken Paoletti
// All rights reserved

#ifndef WALLH
#define WALLH

class MEDIA ;

class WALL
{
public:

  WALL(walldata, wall_element *, char);
// There is no copy construtor because the current design of GnuRad 
// does not require one. If there is a change it may be required and 
// will have to be added for GnuRad to work properly.

  ~WALL(void);
  void addmedia(MEDIA *) ;
  char wtype(void) const ; // Reports the wall type
  int other_box(void) const; // Reports the other box the wall is part of => virtual wall
  void print(FILE *, char); 
  void receive(Bundleinfo);
  unsigned long received(void) const ; // Reports the numof bundles received
  void sendall(void);
  unsigned long sent(void) const ;
  char iterate(void);
  void reset(void);
  

private:

  int find_elem(void) ;
  void pgraph(FILE *) ;
  void ptable(FILE *) ;
  void pspread(FILE *) ;
  void plot(FILE *) ;
  void reflect(int, char) ;
  void transform(void) ;

  Bundleinfo intobox(int boxwall, int i, int j);
  MEDIA *media ;
  char type ;
  char mode ;
  int w_num[2] ;
  int e_num[2] ;
  int nel ;
  int meshx ;
  int meshy ;
  double delx ;
  double dely ;
  double boxX ;
  double boxY ;
  double boxZ ;
  double area ; 
  double bun_e ;
  unsigned long bun_s ;
  double loc_x ;
  double loc_y ;
  double norm[3] ;
  double R ;
  double *emis ;
  double *reflect_S ;
  double *reflect_D ;
  unsigned long *send ;
  unsigned long *rec ;
  double iter_fac ;
  int iter_num ;
  int max_iter ;
  double max_per ;
  double *q ;
  Bundleinfo bundle ;
};

#endif
