// GnuRad 
// Copyright 1997, Ken Paoletti
// All rights reserved

#define VERSION "B01"  // Version number of the program

struct modeldata
{
  int nbox ;   // Number of boxes in the model
  char mode ; // Model Mode
}  ;
  
struct boxdata
{
  int e_num ;
  double length[3] ;  // length[0]=X, length[1]=Y, length[2]=Z
} ;

struct walldata
{
  int w_num[2]  ; // Wall number ID (It may be 2 if the wall is virtual)
  int e_num[2] ;  // Element number ID
  double norm[3] ; // Unit norm
  double boxl[3] ; // The box dimensions
  double loc_x ; // Local x length
  double loc_y ; // Local y length
  int meshx ;    // Number of meshed grid on the x axis
  int meshy ;    // Number of meshed grid on the y axis 
  char type ;    // Type of Wall 'R' - real 'V' - virtual
  double emis ;  // Emissivity
  double reflect_D ; // Diffuse refectivity
  double reflect_S ; // Specular refectivity
                     // NOTE: emis and reflect_D and reflect_S must add to 1.00
  double temp ;  // Temperature (set to 0.0 for unknown)
  double bun_e ; // Bundle energy - Temp mode
  unsigned long bun_s ; // Bundles to send per unit area - View mode
  double iter_fac ; // Iteration factor
  int max_iter ;   // Maximum #'s of iteration loops
  double max_per ; // Maximum percent error
} ;

struct wall_element
{
  double temp ;       // Temperature of a wall element
  double emis ;       // Emissivity of a wall element
  double reflect_S ;  // Diffuse refectivity of a wall element
  double reflect_D ;  // Specular refectivity of a wall element
  double qnet ;       // Net flux of a wall element
} ;

struct mediadata
{
  int e_num ; // Element number it belongs too
  double X ;  // X length
  double Y ;  // Y length
  double Z ;  // Z length
  int meshx ;    // Number of meshed grid on the x axis
  int meshy ;    // Number of meshed grid on the y axis 
  int meshz ;    // Number of meshed grid on the z axis 
  char type ;     // Type  'T' - temp 'U' - unknown 'C' - clear 
  char mode ;    // Mode 'T' - temp 'E' - energy 'V' - rad. exch. fact.
  char scat ;    // Type of scattering 'I' - isotropic
  double ssal ;  // Single scattering albedo
  double Ke ;    // Extinction coeff. per meter
  double p[6] ;    // Addition parameter for S2 & S3 scattering models
  double temp ;  // Temperature (set to 0.0 for unknown)
  double bun_e ; // Bundle energy - Temp mode
  double iter_fac ; // Iteration factor
  int max_iter ;   // Maximum #'s of iteration loops
  double max_per ; // Maximum percent error
} ;

struct med_element
{
  double temp ;  // Teperature of a media element
  double qnet ;  // Net flux of a media element
} ;

struct Bundleinfo
{
  double dir[3] ;   // direction expressed as components of a unit vector
  double pos[3] ;   // position expressed as components of a unit vector
  double optl ;     // Optical length the bundle has travelled since last
                    // interaction 
  double optlext ;  // Optical length to next interaction
} ;

