// GnuRad 
// Copyright 1997, Ken Paoletti
// All rights reserved
#include<stdlib.h>
#include<stdio.h>
#include <string.h>
#include <assert.h>
#include <ctype.h>
#include "scan.h"

SCAN::SCAN(char *filename)
// Construct a SCAN object.
{
  char *result ;
  assert(filename != 0);
  if( (fp = fopen(filename, "r")) == 0)   // Open the file.
    {
      fprintf(stderr,"\nThe file '%s' could not be opened.\n", filename);
      exit(0);
    }
  line = new char[200];		// Create the line buffer.
  token = new char[100];	// Create the token buffer.
  assert(line != 0);
  assert(token != 0);
  result = fgets(line, 200, fp); // Read a line.
  assert(result != 0);
  current = line;		 // Set pointer to current.
  lnum = 1;
}

// There is no copy construtor because the current design of GnuRad 
// does not require one. If there is a change it may be required and 
// will have to be added for GnuRad to work properly.

SCAN::~SCAN(void)
// Destroy a scan object.
{
  delete [] line;
  delete [] token;
}

int SCAN::done(void)
{
  return (strlen(token) == 0);
}

char *SCAN::current_line(void)
// Return the current line
{
  return(line);
}

int SCAN::line_num(void)
{
  return(lnum);
}

char *SCAN::advance(void)
// Advance to the next lexical token.
{
  char *eof ="EOF";
  char *token_ptr;	// Pointer to the token buffer.

  /* clear token text buffer */
  token[0] = '\0';
  token_ptr = token;

  do
    { // skip any leading whitespace
      while (isspace(*current) || *current == '(' || *current == ')' || *current == ','|| *current == ';' || *current == ':')
	{
	  current++;
	}

      /* end of line is \n or '\0' or '#' */
      if (*current == '\0' || *current == '\n' || *current == '#')
	{
	  if ((fgets(line, 200, fp)) == 0)
	    {
	      return(eof);	// end of file -- bale out
	    }
	  current = line;
          lnum ++ ;
	}
    } 
  while (isspace(*current) || *current == '#');

  /* start of a token */
  while (!isspace(*current) && *current != '(' && *current != ')' && *current != ',' && *current != ';' && *current != ':')
    {
      *token_ptr++ = *current++;
    }
  *token_ptr = '\0';	// end of string

  toup();
  return(token);

}	/* end advance */

void SCAN::toup()
{
  int i, n ;

  n = strlen(token);
  for( i= 0 ; i < n ; i++ )
    {
      token[i] = (char)toupper( (int)token[i]);
    }
}

