// GnuRad 
// Copyright 1997, Ken Paoletti
// All rights reserved
class MODEL ;

// PARSER class definition:
class PARSER : public SCAN
{
public:
  PARSER(char *filename);
// There is no copy construtor because the current design of GnuRad 
// does not require one. If there is a change it may be required and 
// will have to be added for GnuRad to work properly.

  ~PARSER(void);
  void rmode(void);
  void rmodel(void);
  void rbox(void);
  void rwall(void);
  void rmedia(void);
  void rpart(void);
  MODEL *Build_model(void);

  char *token;

private:
  void advance(void);
  char *current_line(void);
  int line_num(void);
  void rtemp(char);
  void setnorm(void);
  void setlocal(void);
  void setw_el(void);
  void runknown(void);
  void rvirtual(void);
  void rview(char);
  void rclear(void);
  void rmed(char);
  void rmed_el(void);
  void rmedunk(void);
  void rwall_el(void);
  void set_med_el(void);
  void kwerror(void);
  void modeerror(void);
  void modelerror(void);
  void bundleerror(void);
  void boxerror(void);
  void wallerror(void);
  void mederror(void);
  void parterror(void);
  void itererror(void);
  void range_error(void);
  void sumerror(double);
  void riter(char);
  walldata wdat ;
  wall_element *welement ;
  boxdata bdat ;
  modeldata moddat ;
  mediadata mdat ;
  med_element *melement ;

  int ptest ;
  char mode;           // Mode, either temperature or view
  double bun_e ;          // Bundle energy - Temp mode
  unsigned long bun_s ;    // Bundles to send per unit area - View mode
  int lnum ;
};
