// Gnurad 
// Copyright 1997, Ken Paoletti
// All rights reserved
#ifndef MEDIAH
#define MEDIAH

class WALL ;

class MEDIA
{
public:

  MEDIA(mediadata, med_element *) ;
// There is no copy construtor because the current design of Gnurad 
// does not require one. If there is a change it may be required and 
// will have to be added for Gnurad to work properly.

  ~MEDIA(void) ;
  void print(FILE *fptr, const char type) ; // Prints Media information 
  void sendall(void) ;
  void  addwall(WALL *, const int) ;
  void receive(Bundleinfo) ;
  double dimension(const int) const ;
  char iterate(void) ;
  void reset(void) ;

private:

  void Isotropic_scatter(void) ;
  void S2_scat(void) ;
  void S3_scat(void) ;
  int find_elem(void) const ;
  void move_bundle(double) ;
  void pgraph(FILE *) ;
  void pspread(FILE *) ;
  void ptable(FILE *) ;
  double to_wall(int *) const ;

  WALL *wall[6] ;
  char mode ;
  char type ;
  char scat ;
  int e_num ;
  int nel ;
  int meshx ;
  int meshy ;
  int meshz ;
  double delx ;
  double dely ;
  double delz ;
  double dim[3] ;
  double volume ; 
  double bun_e ;

  //------- Participating Media properties --------

  // Extinction coefficient & Single scattering albedo (Omega)
  double Ke ;
  double ssal ;
  double p[6] ;

  unsigned long *send ;
  unsigned long *rec ;
  double iter_fac ;
  int iter_num ;
  int max_iter ;
  double max_per ;
  double *qm ;
  Bundleinfo bundle ;
};

#endif





