// GnuRad 
// Copyright 1997, Ken Paoletti
// All rights reserved

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "struct.h"
#include "scan.h"
#include "parser.h"
#include "box.h"
#include "wall.h"
#include "media.h"
#include "model.h"
                                
int main(int, char **);                                
void getoptions(char, char **);
void ptemp(int) ;  // Prints the TEMPERATURE mode info of the model
void prt_view_mode(int) ;  // Prints the VIEW mode info of the model
char user_input[100], base_output_fname[100] ;
FILE *fp[4] ; 
double Qnet = 0.0 ; // Qnet is the total energy balance of the model
                    // If the model ran correctly, Qnet should be approx. ZERO
MODEL *model ;


//-------- Get options from the command line --------
void getoptions(int argc, char *argv[]) 
{

  if(argc == 1 )
    {
	  fprintf(stdout,"\n GnuRad version %s \n\n\n",VERSION) ;
      fprintf(stdout," Enter the input file name.\n\n>");
      cin>>user_input ;
    }
  else
    {
      strcpy(user_input,argv[1]) ;
    }

  if(argc > 2)
    {
      strcpy(base_output_fname,argv[2]) ;
    }
}
//---------------- Print Temperature Mode info ---------------

void ptemp(int argc)
{ 
  char name[80] ;
  char *ext[4] = { ".tbl", ".tgr", ".csv", ".plt" } ;
  int i ;
  if(argc < 3)
    {
	  fprintf(stdout," GnuRad version  %s\n\n\n",VERSION) ;
      model->print(stdout, 'T');
      fprintf(stdout,"\n\n>>>>>>> Net Energy of the model = %9g <<<<<<<<\n",Qnet);
    }
  else
    {
      for(i = 0; i < 4; i++)
	{
	  strcpy(name,base_output_fname);
	  strcat(name,ext[i]) ;
	  if( (fp[i] = fopen(name,"w")) == NULL )
	    {
	      fprintf(stderr," Cannnot open file >%s\n",name);
	      exit(2);
	    }
	}
	  fprintf(fp[0]," GnuRad version  %s\n\n\n",VERSION) ;
      model->print(fp[0], 'T');
      fprintf(fp[0],"\n\n>>>>>>> Net Energy of the model = %9g <<<<<<<<\n",Qnet);
	  fprintf(fp[1]," GnuRad version  %s\n\n\n",VERSION) ;
      model->print(fp[1], 'G');
      fprintf(fp[1],"\n\n>>>>>>> Net Energy of the model = %9g <<<<<<<<\n",Qnet);
	  fprintf(fp[2],"*** GnuRad version  %s***\n\n\n",VERSION) ;
      model->print(fp[2], 'S');
	  fprintf(fp[3]," # GnuRad version  %s\n #\n #\n",VERSION) ;
      model->print(fp[3], 'P');
      fclose(fp[0]);
      fclose(fp[1]);
      fclose(fp[2]);
      fclose(fp[3]);
    }

}
//---------------- Print View FactorMode info ---------------

void prt_view_mode(int argc)
{ 
  char name[80] ;
  char *ext[1] = { ".vwf" } ;

  if(argc < 3)
    {
	  fprintf(stdout," GnuRad version  %s\n\n\n",VERSION) ;
      model->pview(stdout, 'V');
    }
  else
    {
	  strcpy(name,base_output_fname);
	  strcat(name,ext[0]) ;
	  if( (fp[0] = fopen(name,"w")) == NULL )
	    {
	      fprintf(stderr," Cannnot open file >%s\n",name);
	      exit(2);
	    }
	  fprintf(fp[0]," GnuRad version  %s\n\n\n",VERSION) ;
	  // Both print methods are required for View mode
      model->print(fp[0], 'T');
      model->pview(fp[0], 'V');
      fclose(fp[0]);
    }

}
//--------------------- MAIN ----------------------

int main(int argc, char **argv)
{
  char mode ;

  getoptions(argc, argv) ;

  PARSER go(user_input);

  fprintf(stdout," Building the Model\n\n");
  model = go.Build_model();
  mode = model->mode();

  if(mode == 'T' )
    {
      model->connect();
      model->run();
      ptemp(argc);
    }
  if(mode == 'V')
    {
      model->connect();
      model->run();
      prt_view_mode(argc);
    }
  delete model ;
}


