// GnuRad 
// Copyright 1997, Ken Paoletti
// All rights reserved

#ifndef BOXH
#define BOXH

const int NUM_WALLS = 6 ; // Six is OK unless the deffinition of a box changes
const int DIMENSIONS = 3 ; // GnuRad is limited to 3 dimension 

class WALL ;
class MEDIA ;

class BOX
{
public:

  //constructor
  BOX(boxdata bdat) ;
// There is no copy construtor because the current design of GnuRad 
// does not require one. If there is a change it may be required and 
// will have to be added for GnuRad to work properly.
  //destructor
  ~BOX(void) ;

  // member functions (methods)
  // these two methods DO change the object data members
  void add_w(WALL *Wptr, int wall_num) ;
  void add_m(MEDIA *Mptr) ; 

  // these methods DO NOT change the data members
  void join(void) const ;
  char wall_type(int) const;
  int joining_box(int) const ;
  void join_boxes(int, MEDIA *mptr) const;
  unsigned long received(void) const;
  void sendall(void) const ;
  unsigned long sent(void) const;
  void print(FILE *fptr, char type)  ;
  char iterate(void) const ;
  void reset(void) const ;
  MEDIA *media_ptr(void) const;


private:

  // data members
  WALL *wall[NUM_WALLS];
  MEDIA *media ;
  double length[DIMENSIONS] ;
  int e_num ;

  // member functions (methods)
  void pelem(FILE *fptr) ;
  void plot_hdr(FILE *fptr) ;

}; 

#endif
